package com.mgtv.ota.ui.test;

import android.content.ContentProvider;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;

/**
 * AbstractContentProvider Copyright by MGTV.COM in ContentP
 * Created by liyaoyan on 2018/5/4 10:25.
 * Email:helloalvin@163.com
 * Modify time:
 * 备注：提供给适配方的最终抽象provider
 */

public abstract class AbstractContentProvider extends ContentProvider {
    private final String TAG = AbstractContentProvider.class.getSimpleName();

    /**
     * 实现的provider的Auth声明
     */
    private final String MGTV_PROVIDER_AUTHORITY = "content://com.mgtv.os.provider";
    /**
     * 获取设备信息的方法名
     */
    private final String GET_DEVICE_METHOD = "getdevice";
    /**
     * 获取设备品牌或厂家方法名
     */
    private final String ARG_DEVICE_BRAND = "device_brand";
    /**
     * 获取有线网络MAC地址方法名
     */
    private final String ARG_DEVICE_MAC = "device_mac";
    /**
     * 获取设备主芯片制造商方法名
     */
    private final String ARG_DEVICE_CHIP_MANUFACTURE = "device_chip_manufacture";
    /**
     * 获取设备主芯片型号方法名
     */
    private final String ARG_DEVICE_CHIP_MODEL = "device_chip_model";
    /**
     * 获取设备机型方法名
     */
    private final String ARG_DEVICE_MODEL = "device_model";
    /**
     * 获取设备当前编译的ROM utc 时间方法名
     */
    private final String ARG_DEVICE_UTC = "device_utc";
    /**
     * 获取设备系统版本，返回当前系统版本号方法名，需要实现，用作ota升级检测的维度之一,
     * 用于做系统升级时候的一个判断基准，当系统升级之后，这个值可能会改变
     */
    private final String ARG_DEVICE_OS_ROM_VERSION = "device_os_rom_version";
    /**
     * 设备系统版本线，返回例如：开发版本：dev，正式版本：release
     */
    private final String ARG_DEVICE_OS_LINE = "device_os_line";


    @Override
    public boolean onCreate() {
        Log.i(TAG, "onCreate");
        return false;
    }

    @Nullable
    @Override
    public Bundle call(@NonNull String method, @Nullable String arg, @Nullable Bundle extras) {
        Log.i(TAG, "call:" + method + "," + arg);
        if (extras == null) extras = new Bundle();
        switch (method) {
            case GET_DEVICE_METHOD:
                switch (arg) {
                    case ARG_DEVICE_BRAND:
                        extras.putString(ARG_DEVICE_BRAND, getBrand());
                        break;
                    case ARG_DEVICE_MAC:
                        extras.putString(ARG_DEVICE_MAC, getDeviceMAC());
                        break;
                    case ARG_DEVICE_CHIP_MANUFACTURE:
                        extras.putString(ARG_DEVICE_CHIP_MANUFACTURE, getChipManufacture());
                        break;
                    case ARG_DEVICE_CHIP_MODEL:
                        extras.putString(ARG_DEVICE_CHIP_MODEL, getChipModel());
                        break;
                    case ARG_DEVICE_MODEL:
                        extras.putString(ARG_DEVICE_MODEL, getDeviceModel());
                        break;
                    case ARG_DEVICE_UTC:
                        extras.putString(ARG_DEVICE_UTC, getDeviceUTC());
                        break;
                    case ARG_DEVICE_OS_ROM_VERSION:
                        extras.putString(ARG_DEVICE_OS_ROM_VERSION, getDeviceVersion());
                        break;
                    case ARG_DEVICE_OS_LINE:
                        extras.putString(ARG_DEVICE_OS_LINE, getOSROMVersionLine());
                        break;
                    default:
                        break;
                }
                break;
            default:
                break;
        }
        return extras;
    }

    /**
     * 获取设备品牌或厂家，例如:imago,合作方自定义,需要实现,不要有空格
     */
    public abstract String getBrand();

    /**
     * 获取设备机型，返回例如：55MZ1,需要实现，用作ota字段之一且作为同一类型设备的唯一key,不要有空格
     */
    public abstract String getDeviceModel();

    /**
     * 获取设备主芯片制造商，返回例如：hisi，需要实现，用作ota字段之一,不要有空格
     */
    public abstract String getChipManufacture();

    /**
     * 获取设备主芯片型号，返回例如：v620，需要实现，用作ota字段之一,不要有空格
     */
    public abstract String getChipModel();

    /**
     * 获取有线网络MAC地址，返回格式例如：FC-A3-86-29-84-E6，需要实现
     */
    public abstract String getDeviceMAC();

    /**
     * 获取设备当前编译的ROM utc 时间，返回例如：1525415001,需要实现，用作ota版本比较的值之一
     */
    public abstract String getDeviceUTC();

    /**
     * 获取设备系统版本，返回当前系统版本号，需要实现，用作ota升级检测的维度之一,
     * 用于做系统升级时候的一个判断基准，当系统升级之后，这个值可能会改变
     */
    public abstract String getDeviceVersion();

    /**
     * 获取设备系统版本线，需要实现，类似 dev 或者 release等，用作ota升级检测的字段之一,不要有空格
     */
    public abstract String getOSROMVersionLine();

}
