/*
 * Copyright (C) 2018 MGTV Service
 * 1. brodcast intercept
 * 2. service intercept
 * 3. others
 *
 */

package com.android.server.am;

import android.content.BroadcastReceiver;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Message;
import android.util.Slog;
import android.content.pm.ResolveInfo;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.Intent;
import android.app.AppGlobals;
import android.os.Process;
import android.content.pm.ApplicationInfo;
import android.os.UserHandle;
import android.os.SystemProperties;
import android.content.pm.PackageManager;
import android.os.SystemClock;
import android.app.ApplicationErrorReport;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

/**
 * Created by penglin on 2018/4/24.
 */

public class MGTVInjector {
    public static final String TAG = "MGTVInjector";

    public static class ActivityManagerServiceHook {
        private static final String SYSTEM_AUTO_START_WHITE_LIST =
                "/system/pmservice/mui_bootr_white_list.json";
        private static final String DATA_AUTO_START_WHITE_LIST =
                "/data/pmservice/mui_bootr_white_list.json";
        private static final String DATA_AUTO_START_BLACK_LIST =
                "/data/pmservice/mui_bootr_black_list.json";
        private static boolean isAutoStartIntercept = SystemProperties.getBoolean(
                "persist.mgtv.auto.start", true);
        public static boolean isDEBUG = SystemProperties.getBoolean(
                "persist.mgtv.debug", false);

        /**
         * auto start about ACTION_BOOT_COMPLETED (invalid, use broadcastIntercept instead of this)
         * @param autoStartWhiteList 
         * @param autoStartBlackList 
         * @param intent
         * @param skipPackages
         * @param receivers
         * @param context
         */
        public static void bootCompleteIntercept (List<String> autoStartWhiteList,
                                                  List<String> autoStartBlackList, Intent intent,
                                                  String[] skipPackages, List receivers,
                                                  Context context) {
            if (!isAutoStartIntercept) {
                if (isDEBUG) {
                    Slog.w(TAG, "isAutoStartIntercept is false so wo do not intercept.");
                }
                return;
            }
            if (null == autoStartWhiteList) {
                if (isDEBUG) {
                    Slog.w(TAG, "autoStartWhiteList is null so wo do not intercept.");
                }
                return;
            }
            if(Intent.ACTION_BOOT_COMPLETED.equals(intent.getAction()) && skipPackages == null){
                try{
                    if (isDEBUG) {
                        if (null != autoStartWhiteList) {
                            for (String auto : autoStartWhiteList) {
                                Slog.w(TAG, "bootCompleteIntercept, autoStartWhiteList: " + auto);
                            }
                        } else {
                            Slog.w(TAG, "bootCompleteIntercept, autoStartWhiteList is null");
                        }
                    }
                    int NT = receivers.size();
                    for (int it=0; it<NT; it++) {
                        ResolveInfo curt = (ResolveInfo)receivers.get(it);
                        boolean isCoreApp = isCoreApp(curt.activityInfo.packageName, context);
                        Slog.w(TAG, curt.activityInfo.packageName + "; " + isCoreApp);
                        if ((null != autoStartWhiteList &&
                                ! autoStartWhiteList.contains(curt.activityInfo.packageName) &&
                                ! isCoreApp) || (null != autoStartBlackList &&
                                autoStartBlackList.contains(curt.activityInfo.packageName))) {
                            if (isDEBUG) {
                                Slog.w(TAG, "MGTV skipPackage:" + curt.activityInfo.packageName);
                            }
                            receivers.remove(it);
                            it--;
                            NT--;
                        }
                    }
                }catch (Exception e) {
                    Slog.e(TAG, "Error bootCompleteIntercept ", e);
                }
            }
        }

        /**
         * broadcast intercept
         * @param info
         * @param r
         * @return
         */
        public static boolean broadcastIntercept(ResolveInfo info, BroadcastRecord r,
                ActivityManagerService mService) {
            if (!isAutoStartIntercept) {
                if (isDEBUG) {
                    Slog.w(TAG, "isAutoStartIntercept is false so wo do not intercept.");
                }
                return false;
            }
            try {
                /*if (info.activityInfo.packageName.equals(r.callerPackage)) {
                    if (isDEBUG) {
                        Slog.w(TAG, "Broadcast pass app: " + info.activityInfo.packageName +
                                " callerPackage:" + r.callerPackage);
                    }
                    return false;
                }*/
                //еӦýᱻ
                if (null != ActivityManagerService.autoStartBlackList && null != info &&
                        null != info.activityInfo &&
                        ActivityManagerService.autoStartBlackList.contains(info.activityInfo.packageName)) {
                    Slog.w(TAG, "autoStartBlackList, Broadcast intercept app: " +
                            info.activityInfo.packageName);
                    return true;
                }
                PackageInfo pInfo = null;
                try {
                    pInfo = AppGlobals.getPackageManager().getPackageInfo(
                            info.activityInfo.packageName, 0, UserHandle.getUserId(r.callingUid));
                } catch (Exception e) {
                    Slog.e(TAG, "Error broadcastIntercept ", e);
                }
                if (pInfo == null || pInfo.applicationInfo == null) {
                    if (isDEBUG) {
                        Slog.w(TAG, "Broadcast pass app, pInfo == null || pInfo.applicationInfo == null");
                    }
                    return false;
                }
                int pkgUid = pInfo.applicationInfo.uid;
                if (pInfo.coreApp || pkgUid == Process.SYSTEM_UID || pkgUid == Process.PHONE_UID
                        || pkgUid == Process.SHELL_UID) {
                    if (isDEBUG) {
                        Slog.w(TAG, "Broadcast pass app: " + info.activityInfo.packageName +
                                " coreApp:" + pInfo.coreApp + " pkgUid:" + pkgUid);
                    }
                    return false;
                }
                if (isPrivApp(info.activityInfo.packageName, mService.mContext)) {
                    if (isDEBUG) {
                        Slog.w(TAG, "Broadcast pass app: " + info.activityInfo.packageName +
                                " is priv-app.");
                    }
                    return false;
                }
                if ((null != ActivityManagerService.autoStartWhiteList &&
                        ActivityManagerService.autoStartWhiteList.contains(
                                info.activityInfo.packageName))) {
                    if (isDEBUG) {
                        Slog.w(TAG, "Broadcast pass app: "+ info.activityInfo.packageName);
                    }
                    return false;
                } else {
                    Slog.w(TAG, "Broadcast intercept app: "+ info.activityInfo.packageName);
                    return true;
                }
            } catch (Exception e) {
                Slog.e(TAG, "Error broadcastIntercept ", e);
            }
            return false;
        }

        /**
         * service intercept
         * @param createIfNeeded
         * @param callingUid
         * @param r
         * @param service
         * @param userId
         * @param ams
         * @return
         */
        public static boolean serviceIntercept(boolean createIfNeeded, int callingUid,
                ServiceRecord r, Intent service, int userId, ActivityManagerService mAm) {
            if (!isAutoStartIntercept) {
                if (isDEBUG) {
                    Slog.w(TAG, "isAutoStartIntercept is false so wo do not intercept.");
                }
                return false;
            }
            try {
                if (!createIfNeeded
                        || callingUid == Process.ROOT_UID || callingUid == Process.SYSTEM_UID
                        || callingUid == Process.PHONE_UID) {
                    if (isDEBUG) {
                        Slog.w(TAG, "Service pass app: " + service + " createIfNeeded:" +
                                createIfNeeded + " callingUid:" + callingUid);
                    }
                    return false;
                }
                PackageInfo info = null;
                try {
                    info = AppGlobals.getPackageManager().getPackageInfo(r.packageName, 0, userId);
                } catch (Exception e) {
                    Slog.e(TAG, "Error serviceIntercept ", e);
                }
                if (info == null || info.applicationInfo == null) {
                    if (isDEBUG) {
                        Slog.w(TAG, "Service pass app: " + service + " ---info is null");
                    }
                    return false;
                }

                //еӦýᱻ
                if (null != ActivityManagerService.autoStartBlackList && null != r &&
                        ActivityManagerService.autoStartBlackList.contains(r.packageName)) {
                    Slog.w(TAG, "autoStartBlackList, Service intercept app: " + r.packageName);
                    return true;
                }

                int pkgUid = info.applicationInfo.uid;
                if (info.coreApp || pkgUid == Process.SYSTEM_UID || pkgUid == Process.PHONE_UID) {
                    if (isDEBUG) {
                        Slog.w(TAG, "Service pass app: " + service + " ----info.coreApp:" +
                                info.coreApp + " pkgUid:" + pkgUid);
                    }
                    return false;
                }
                if (r.appInfo.uid == callingUid) {
                    if (isDEBUG) {
                        Slog.w(TAG, "Service pass app: " + service + " ----r.appInfo.uid:" +
                                r.appInfo.uid + " callingUid:" + callingUid);
                    }
                    return false;
                }
                if (isPrivApp(r.packageName, mAm.mContext)) {
                    if (isDEBUG) {
                        Slog.w(TAG, "Service pass app: " + service + " " + r.packageName +
                                " is priv-app.");
                    }
                    return false;
                }
                /*boolean pkgStopped = (info.applicationInfo.flags & ApplicationInfo.FLAG_STOPPED) != 0;
                if (!pkgStopped) {
                    if (isDEBUG) {
                        Slog.w(TAG, "Service pass non-stopped app: "+ service);
                    }
                    return false;
                } else {
                    if (null != ActivityManagerService.autoStartWhiteList &&
                            !ActivityManagerService.autoStartWhiteList.contains(
                            r.packageName)) {
                        Slog.w(TAG, "Service intercept app: "+ service);
                        return true;
                    }
                }*/
                if (null != ActivityManagerService.autoStartWhiteList &&
                        !ActivityManagerService.autoStartWhiteList.contains(
                                r.packageName)) {
                    Slog.w(TAG, "Service intercept app: "+ service);
                    return true;
                }
            } catch (Exception e) {
                Slog.e(TAG, "Error serviceIntercept ", e);
                e.printStackTrace();
            }
            if (isDEBUG) {
                Slog.w(TAG, "Service pass app in the end of serviceIntercept: "+ service);
            }
            return false;
        }

        /**
         * service interfacept in killServicesLocked
         * @param app
         * @param mAm
         * @return
         */
        public static boolean killServicesLockedIntercept(ProcessRecord app,
                                                          ActivityManagerService mAm) {
            if (!isAutoStartIntercept) {
                if (isDEBUG) {
                    Slog.w(TAG, "isAutoStartIntercept is false so wo do not intercept.");
                }
                return false;
            }
            try {
                if (null ==app  || null == app.info) {
                    return false;
                }
                //еӦýᱻ
                if (null != ActivityManagerService.autoStartBlackList && null != app && null != app.info &&
                        ActivityManagerService.autoStartBlackList.contains(app.info.packageName)) {
                    Slog.w(TAG, "autoStartBlackList, Service intercept app: " + app.info.packageName);
                    return true;
                }
                if (isPrivApp(app.info.packageName, mAm.mContext)) {
                    if (isDEBUG) {
                        Slog.w(TAG, "killServicesLocked pass app: " + app.info.packageName +
                                " is priv-app.");
                    }
                    return false;
                }
                if (isCoreApp(app.info.packageName, mAm.mContext)) {
                    if (isDEBUG) {
                        Slog.w(TAG, "killServicesLocked pass app: " + app.info.packageName +
                                " is coreApp.");
                    }
                    return false;
                }
                if (null != ActivityManagerService.autoStartWhiteList
                        && !ActivityManagerService.autoStartWhiteList.contains(app.info.packageName)) {
                    Slog.w(TAG, "killServicesLocked intercept app: " + app.info.packageName);
                    return true;
                }
            } catch (Exception e) {
                Slog.e(TAG, "Error killServicesLockedIntercept ", e);
                e.printStackTrace();
            }
            return false;
        }

        /**
         * send broadcast com.mgtv.anrsurveyor.ANREvent
         * @param context
         * @param app
         */
        public static void anrEventBroadcast(Context context, ProcessRecord app) {
            try {
                Intent intent = new Intent();
                intent.setAction("com.mgtv.anrsurveyor.ANREvent");
                intent.putExtra("info", "act=anr" + "&ap=" + app.processName);
                context.sendBroadcastAsUser(intent, UserHandle.OWNER);
            } catch (Exception e) {
                Slog.e(TAG, "Error anrEventBroadcast ", e);
            }
        }

        /**
         * send broadcast com.mgtv.ntpsurveyor.NtpEvent
         * @param context
         */
        public static void ntpEventBroadcast(Context context) {
            try {
                Intent intent = new Intent();
                intent.setAction("com.mgtv.ntpsurveyor.NtpEvent");
                intent.putExtra("info", String.valueOf(SystemClock.elapsedRealtime()));
                context.sendBroadcastAsUser(intent, UserHandle.OWNER);
            } catch (Exception e) {
                Slog.e(TAG, "Error ntpEventBroadcast ", e);
            }
        }

        /**
         * send broadcast com.mgtv.app.state
         * @param context
         * @param app
         */
        public static void appDiedStateBroadcast(Context context, ProcessRecord app) {
            try {
                if(context != null){
                    Intent intent = new Intent("com.mgtv.app.state");
                    intent.putExtra("action", "died");
                    intent.putExtra("packageName", app.processName);
                    intent.putExtra("time", "" + System.currentTimeMillis());
                    context.sendBroadcastAsUser(intent, UserHandle.OWNER);
                }
            } catch (Exception e) {
                Slog.e(TAG, "Error appDiedStateBroadcast ", e);
            }
        }

        /**
         * send broadcast com.mgtv.app.state when app in resume state
         * @param mService
         */
        public static void appStartStateBroadcast(ActivityManagerService mService,
                                                  ActivityRecord next) {
            try {
                if(mService!=null && mService.mContext!=null){
                    Slog.d("mgtv", "com.mgtv.app.state start activityStack");
                    Intent intent = new Intent("com.mgtv.app.state");
                    intent.putExtra("action", "start");
                    intent.putExtra("packageName", next.packageName);
                    intent.putExtra("time", "" + System.currentTimeMillis());
                    mService.mContext.sendBroadcastAsUser(intent, UserHandle.OWNER);
                }
            } catch(Exception e) {
                Slog.e(TAG, "Error appStartStateBroadcast ", e);
            }
        }

        /**
         * send broadcast com.mgtv.anrsurveyor.crashEvent
         * @param eventType
         * @param mContext
         * @param crashInfo
         */
        public static void crashEventBroadcast(String eventType, Context mContext, StringBuilder sb,
                                               final ApplicationErrorReport.CrashInfo crashInfo,
                                               String dropboxTag, String processName) {
            try {
                if ("crash".equals(eventType)) {
                    Intent crashIntent = new Intent();
                    crashIntent.setAction("com.mgtv.anrsurveyor.crashEvent");
                    crashIntent.putExtra("dropboxTag", dropboxTag);
                    crashIntent.putExtra("processName", processName);
                    crashIntent.putExtra("exceptionClassName", crashInfo.exceptionClassName);
                    crashIntent.putExtra("exceptionMessage", crashInfo.exceptionMessage);
                    crashIntent.putExtra("throwFileName", crashInfo.throwFileName);
                    crashIntent.putExtra("throwLineNumber", crashInfo.throwLineNumber);
                    crashIntent.putExtra("headers", sb.toString());
                    mContext.sendBroadcastAsUser(crashIntent, UserHandle.OWNER);
                }
            } catch (Exception e) {
                Slog.e(TAG, "Error sending broadcast com.mgtv.anrsurveyor.crashEvent", e);
            }
        }

        /**
         * send broadcast com.mgtv.app.state when start activity
         * @param intent
         * @param mService
         */
        public static void appStartActivityStateBroadcast(Intent intent,
                                                          ActivityManagerService mService) {
            try {
                if(mService!=null && mService.mContext!=null){
                    Slog.d("mgtv", "com.mgtv.app.state start ActivityStackSupervisor");
                    Intent mgtvIntent = new Intent("com.mgtv.app.state");
                    mgtvIntent.putExtra("action", "start");
                    mgtvIntent.putExtra("packageName", intent.toShortString(true, true, true, false));
                    mgtvIntent.putExtra("time", "" + System.currentTimeMillis());
                    mService.mContext.sendBroadcastAsUser(mgtvIntent, UserHandle.OWNER);
                }
            } catch(Exception e) {
                Slog.e(TAG, "Error appStartActivityStateBroadcast ", e);
                e.printStackTrace();
            }
        }

        /**
         * get auto start white list
         * /system/pmservice/mui_bootr_white_list.json
         * /data/pmservice/mui_bootr_white_list.json
         * @return List<String>
         */
        public static List<String> getAutoStartWhiteList() {
            FileReader fd1 = null, fd2 = null;
            BufferedReader br1 = null, br2 = null;
            List<String> autoStartWhiteList = new ArrayList<String>();
            JSONArray jsonArray1 = null, jsonArray2 = null, jsonArray3 = null, jsonArray4 = null;
            try {
                File file1 = new File(SYSTEM_AUTO_START_WHITE_LIST);
                if (file1.exists() && file1.canRead()) {
                    fd1 = new FileReader(file1);
                    br1 = new BufferedReader(fd1);
                    StringBuilder sb1 = new StringBuilder();
                    String line1;
                    while(null != (line1 = br1.readLine())) {
                        sb1.append(line1.trim());
                    }
                    JSONObject jsonObject1 = new JSONObject(sb1.toString());
                    jsonArray1 = jsonObject1.getJSONArray("system");
                    jsonArray2 = jsonObject1.getJSONArray("mui");
                    jsonArray3 = jsonObject1.getJSONArray("others");
                } else {
                    Slog.w(TAG, SYSTEM_AUTO_START_WHITE_LIST + " is not exists or cannot be read.");
                }
                File file2 = new File(DATA_AUTO_START_WHITE_LIST);
                if (file2.exists() && file2.canRead()) {
                    fd2 = new FileReader(file2);
                    br2 = new BufferedReader(fd2);
                    StringBuilder sb2 = new StringBuilder();
                    String line2;
                    while(null != (line2 = br2.readLine())) {
                        sb2.append(line2.trim());
                    }
                    JSONObject jsonObject2 = new JSONObject(sb2.toString());
                    jsonArray4 = jsonObject2.getJSONArray("applist");
                } else {
                    Slog.w(TAG, DATA_AUTO_START_WHITE_LIST + " is not exists or cannot be read.");
                }
                for (int i = 0; i < (jsonArray1 != null ? jsonArray1.length():0); i++){
                    autoStartWhiteList.add(String.valueOf(jsonArray1.get(i)));
                }
                for (int i = 0; i < (jsonArray2 != null ? jsonArray2.length():0); i++){
                    autoStartWhiteList.add(String.valueOf(jsonArray2.get(i)));
                }
                for (int i = 0; i < (jsonArray3 != null ? jsonArray3.length():0); i++){
                    autoStartWhiteList.add(String.valueOf(jsonArray3.get(i)));
                }
                for (int i = 0; i < (jsonArray4 != null ? jsonArray4.length():0); i++){
                    autoStartWhiteList.add(String.valueOf(jsonArray4.get(i)));
                }
            } catch (Exception e) {
                Slog.w(TAG, "Failure reading " + DATA_AUTO_START_WHITE_LIST, e);
                e.printStackTrace();
            } finally {
                if (null != br1) {
                    try {
                        br1.close();
                    } catch (IOException e) {
                        Slog.e(TAG, "Error closing br1", e);
                    }
                }
                if (null != fd1) {
                    try {
                        fd1.close();
                    } catch (IOException e) {
                        Slog.e(TAG, "Error closing fd1", e);
                    }
                }
                if (null != br2) {
                    try {
                        br2.close();
                    } catch (IOException e) {
                        Slog.e(TAG, "Error closing br2", e);
                    }
                }
                if (null != fd2) {
                    try {
                        fd2.close();
                    } catch (IOException e) {
                        Slog.e(TAG, "Error closing fd2", e);
                    }
                }
            }
            if (isDEBUG) {
                if (null != autoStartWhiteList) {
                    for (String auto : autoStartWhiteList) {
                        Slog.w(TAG, "getAutoStartWhiteList:" + auto);
                    }
                }
            }
            return autoStartWhiteList;
        }

        /**
         * get auto start black list
         * /data/pmservice/mui_bootr_wblack_list.json
         * @return List<String>
         */
        public static List<String> getAutoStartBlackList() {
            FileReader fd = null;
            BufferedReader br = null;
            List<String> autoStartBlackList = new ArrayList<String>();
            JSONArray jsonArray = null;
            try {
                File file = new File(DATA_AUTO_START_BLACK_LIST);
                if (file.exists() && file.canRead()) {
                    fd = new FileReader(file);
                    br = new BufferedReader(fd);
                    StringBuilder sb = new StringBuilder();
                    String line;
                    while(null != (line = br.readLine())) {
                        sb.append(line.trim());
                    }
                    JSONObject jsonObject = new JSONObject(sb.toString());
                    jsonArray = jsonObject.getJSONArray("applist");
                } else {
                    Slog.w(TAG, DATA_AUTO_START_BLACK_LIST + " is not exists or cannot be read.");
                }
                for (int i = 0; i < (jsonArray != null ? jsonArray.length():0); i++){
                    autoStartBlackList.add(String.valueOf(jsonArray.get(i)));
                }
            } catch (Exception e) {
                Slog.w(TAG, "Failure reading " + DATA_AUTO_START_BLACK_LIST, e);
                e.printStackTrace();
            } finally {
                if (null != br) {
                    try {
                        br.close();
                    } catch (IOException e) {
                        Slog.e(TAG, "Error closing br", e);
                    }
                }
                if (null != fd) {
                    try {
                        fd.close();
                    } catch (IOException e) {
                        Slog.e(TAG, "Error closing fd", e);
                    }
                }
            }
            if (isDEBUG) {
                if (null != autoStartBlackList) {
                    for (String auto : autoStartBlackList) {
                        Slog.w(TAG, "autoStartBlackList:" + auto);
                    }
                }
            }
            return autoStartBlackList;
        }

        /**
         * is it a coreApp
         * @param packageName
         * @param context
         * @return
         */
        private static boolean isCoreApp(String packageName, Context context) {
            try {
                PackageInfo pi = context.getPackageManager().getPackageInfo(packageName, 0);
                if (pi.coreApp) {
                    return true;
                }
            } catch (Exception e) {
                Slog.e(TAG, "Error getting package info: " + packageName, e);
            }
            return false;
        }

        /**
         * is the packageName installed in system/priv-app
         * @param packageName
         * @param context
         * @return
         */
        private static boolean isPrivApp(String packageName, Context context) {
            try {
                PackageManager packageManager = context.getPackageManager();
                List<PackageInfo> packageInfoList = packageManager.getInstalledPackages(0);
                for (int i = 0; i < packageInfoList.size(); i++) {
                    PackageInfo pkg = (PackageInfo) packageInfoList.get(i);
                    if(packageName.equals(pkg.packageName) &&
                            pkg.applicationInfo.sourceDir.contains("/system/priv-app/")) {
                        return true;
                    }
                }
            } catch (Exception e) {
                Slog.e(TAG, "Error getting package info: " + packageName, e);
            }
            return false;
        }

    }
}
