/*
 * Copyright (C) 2018 MGTV Service
 * 1. brodcast intercept
 * 2. service intercept
 * 3. others
 *
 */

package com.android.server.am;

import android.util.Slog;
import android.content.pm.ResolveInfo;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.Intent;
import android.app.AppGlobals;
import android.os.Process;
import android.content.pm.ApplicationInfo;
import android.os.UserHandle;
import android.os.SystemProperties;
import android.content.pm.PackageManager;
import android.os.SystemClock;
import android.app.ApplicationErrorReport;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

/**
 * Created by penglin on 2018/4/24.
 */

public class MGTVInjector {
    public static final String TAG = "MGTVInjector";

    public static class ActivityManagerServiceHook {
        private static final String SYSTEM_AUTO_START_WHITE_LIST =
                "/system/pmservice/mui_bootr_white_list.json";
        private static final String DATA_AUTO_START_WHITE_LIST =
                "/data/pmservice/mui_bootr_white_list.json";
        private static boolean isAutoStartIntercept = SystemProperties.getBoolean(
                "persist.mgtv.auto.start", true);
        public static boolean isDEBUG = SystemProperties.getBoolean(
                "persist.mgtv.debug", false);

        /**
         * send broadcast com.mgtv.anrsurveyor.ANREvent
         * @param context
         * @param app
         */
        public static void anrEventBroadcast(Context context, ProcessRecord app) {
            try {
                Intent intent = new Intent();
                intent.setAction("com.mgtv.anrsurveyor.ANREvent");
                intent.putExtra("info", "act=anr" + "&ap=" + app.processName);
                context.sendBroadcast(intent);
            } catch (Exception e) {
                Slog.e(TAG, "Error anrEventBroadcast ", e);
            }
        }

        /**
         * send broadcast com.mgtv.ntpsurveyor.NtpEvent
         * @param context
         */
        public static void ntpEventBroadcast(Context context) {
            try {
                Intent intent = new Intent();
                intent.setAction("com.mgtv.ntpsurveyor.NtpEvent");
                intent.putExtra("info", String.valueOf(SystemClock.elapsedRealtime()));
                context.sendBroadcast(intent);
            } catch (Exception e) {
                Slog.e(TAG, "Error ntpEventBroadcast ", e);
            }
        }

        /**
         * send broadcast com.mgtv.app.state
         * @param context
         * @param app
         */
        public static void appDiedStateBroadcast(Context context, ProcessRecord app) {
            try {
                if(context != null){
                    Intent intent = new Intent("com.mgtv.app.state");
                    intent.putExtra("action", "died");
                    intent.putExtra("packageName", app.processName);
                    intent.putExtra("time", "" + System.currentTimeMillis());
                    context.sendBroadcast(intent);
                }
            } catch (Exception e) {
                Slog.e(TAG, "Error appDiedStateBroadcast ", e);
            }
        }

        /**
         * send broadcast com.mgtv.app.state when app in resume state
         * @param mService
         */
        public static void appStartStateBroadcast(ActivityManagerService mService,
                                                  ActivityRecord next) {
            try {
                if(mService!=null && mService.mContext!=null){
                    Slog.i("mgtv", "com.mgtv.app.state start activityStack");
                    Intent intent = new Intent("com.mgtv.app.state");
                    intent.putExtra("action", "start");
                    intent.putExtra("packageName", next.packageName);
                    intent.putExtra("time", "" + System.currentTimeMillis());
                    mService.mContext.sendBroadcast(intent);
                }
            } catch(Exception e) {
                Slog.e(TAG, "Error appStartStateBroadcast ", e);
            }
        }

        /**
         * send broadcast com.mgtv.anrsurveyor.crashEvent
         * @param eventType
         * @param mContext
         * @param crashInfo
         */
        public static void crashEventBroadcast(String eventType, Context mContext, StringBuilder sb,
                                               final ApplicationErrorReport.CrashInfo crashInfo,
                                               String dropboxTag, String processName) {
            try {
                if ("crash".equals(eventType)) {
                    Intent crashIntent = new Intent();
                    crashIntent.setAction("com.mgtv.anrsurveyor.crashEvent");
                    crashIntent.putExtra("dropboxTag", dropboxTag);
                    crashIntent.putExtra("processName", processName);
                    crashIntent.putExtra("exceptionClassName", crashInfo.exceptionClassName);
                    crashIntent.putExtra("exceptionMessage", crashInfo.exceptionMessage);
                    crashIntent.putExtra("throwFileName", crashInfo.throwFileName);
                    crashIntent.putExtra("throwLineNumber", crashInfo.throwLineNumber);
                    crashIntent.putExtra("headers", sb.toString());
                    mContext.sendBroadcast(crashIntent);
                }
            } catch (Exception e) {
                Slog.e(TAG, "Error sending broadcast com.mgtv.anrsurveyor.crashEvent", e);
            }
        }

        /**
         * send broadcast com.mgtv.app.state when start activity
         * @param intent
         * @param mService
         */
        public static void appStartActivityStateBroadcast(Intent intent,
                                                          ActivityManagerService mService) {
            try {
                if(mService!=null && mService.mContext!=null){
                    Slog.i("mgtv", "com.mgtv.app.state start ActivityStackSupervisor");
                    Intent mgtvIntent = new Intent("com.mgtv.app.state");
                    mgtvIntent.putExtra("action", "start");
                    mgtvIntent.putExtra("packageName", intent.toShortString(true, true, true, false));
                    mgtvIntent.putExtra("time", "" + System.currentTimeMillis());
                    mService.mContext.sendBroadcast(mgtvIntent);
                }
            } catch(Exception e) {
                Slog.e(TAG, "Error appStartActivityStateBroadcast ", e);
                e.printStackTrace();
            }
        }

    }
}
