const common = require('./webpack.common');
const webpack = require('webpack');
const { merge } = require('webpack-merge');
// 带plugin的需要在此配置require

module.exports = merge(common, {
  mode: 'development',
  plugins: [
    // 设置全局变量
    new webpack.DefinePlugin({
      'process.env': "'development'",
    }),
  ],
  devtool: 'cheap-module-eval-source-map',
  devServer: {
    open: true, //开启本地服务时是否打开浏览器
    // host: '192.168.3.2', //本地服务地址
    // host: '192.168.43.160', //本地服务地址
    hotOnly: true,
    port: 3500, ////本地服务端口

    proxy: [
      {
        context: [
          '/ad/ssp/iptv/config',
          '/feedback/app',
          '/ssp/api/ad',
          '/thirdyda',
          '/feedback/err',
        ],
        target: 'http://adtest.yys.mgtv.com/',
        // 默认情况下，代理时会保留主机头的来源，可以将 changeOrigin 设置为 true 以覆盖此行为
        changeOrigin: true,
        // 默认情况下，将不接受在 HTTPS 上运行且证书无效的后端服务器。 如果需要,设置为false
        secure: false,
      },
      {
        context: ['/cdn'],
        target: 'http://adc.yys.mgtv.com/',
        changeOrigin: true,
        secure: false,
      },
    ],
  },
});
