window.onload = () => {
  var video = document.createElement('video');
  video.src = '/assets/mgtvAlpha.mp4';
  video.width = 1280;
  video.height = 360;
  video.autoplay = true;
  video.muted = true;
  video.play();
  const { width, height } = video;
  const halfWidth = width / 2;

  var brokenscreen = document.getElementById('brokenscreen');
  var ctx = brokenscreen.getContext('2d');
  brokenscreen.width = width;
  brokenscreen.height = height;
  computeFrame();
  function computeFrame() {
    if (video.paused || video.ended) {
      return;
    }
    window.requestAnimationFrame(computeFrame);
    ctx.drawImage(video, 0, 0, width, height);
    let frame = ctx.getImageData(0, 0, width, height);
    let l = frame.data.length / 4;
    for (let i = 0; i < l; i++) {
      let g = frame.data[i * 4 + 1];
      frame.data[(i + halfWidth - 1) * 4 + 3] = g;
      if ((i / halfWidth) % 2 === 1) {
        i += halfWidth;
      }
    }
    ctx.clearRect(0, 0, width, height);
    ctx.putImageData(frame, -halfWidth, 0);
    return;
  }
};
