import './index.scss';
import $ from '../../utils/dom';
import '../../sdk/adunion.min';
import clientParams from '../../model/exampleClient';
import vic from '../../model/exampleVic';
import { isVisible } from '../../utils/visiableChecker';

var pauseAdC;
var isPause = false;

if (window.webView) {
  window.onKeyDown = (keycode) => {
    if (
      !isVisible(document.getElementsByClassName('imgadcontainer')[0]) &&
      isPause
    ) {
      videoId.play();
      isPause = false;
    } else {
      $('.imgadcontainer').show();
      pauseAdC.onMaterialShow();
      videoId.pause();
      isPause = true;
    }
  };
}

(() => {
  adunion.init(clientParams);

  const adspacePause = {
    width: 1920,
    height: 1080,
    maxAdCount: 1,
    maxDuration: 15,
    minCpm: 5,
  };

  window.onload = () => {
    adunion.fetchPauseAd(adspacePause, vic, false).then((pauseAd) => {
      const { material_url, name } = pauseAd;
      pauseAdC = pauseAd;
      const imgId = $('#imgId');
      imgId.attr('src', material_url);
      imgId.attr('alt', name);
      const imgContent = $('.imgadcontainer');
      imgId.on('click', () => {
        pauseAd.onMaterialClick();
      });
      $('#videoId').on('pause', (e) => {
        isPause = true;
        imgContent.show();
        pauseAd.onMaterialShow();
      });
      $('.cancle').on('click', () => {
        isPause = true;
        imgContent.hide();
        pauseAd.onMaterialClose();
      });
      $('.quitplay').on('click', () => {
        imgContent.hide();
        pauseAd.onMaterialClose();
        document.getElementById('videoId').play();
      });
    });
  };
})();
