/**
 * H5 video播放视频广告videoPlayer接口实现
 *
 * @export
 * @class VideoPlayer
 */
export class VideoPlayer {
  _isPlaying = false;
  _jumpWeb;
  _videoEle;
  constructor() {
    this._videoEle = document.getElementById('videoId');
    this.getCurrentTime = this.getCurrentTime.bind(this);
  }
  playVideo(material) {
    const { materialId } = material;
    this._videoEle.src = materialId;
  }
  getCurrentTime() {
    return this._videoEle.currentTime;
  }
  setEventCallBack(eventCallBack) {
    this._videoEle.addEventListener('loadeddata', () => {
      eventCallBack('preplay');
      this._isPlaying = true;
      this._videoEle.setAttribute('muted', true);
    });
    this._videoEle.addEventListener('pause', () => {
      eventCallBack('pause');
      this._isPlaying = false;
    });
    this._videoEle.addEventListener('ended', () => {
      eventCallBack('end');
      this._isPlaying = false;
    });
    this._videoEle.addEventListener('error', () => {
      eventCallBack('error');
      this._isPlaying = false;
    });
  }
  playVideoInFrame(material, left, top, width, height) {
    const videoEle = this._videoEle;
    const { materialId } = material;
    videoEle.src = materialId;

    const style = videoEle.style;
    style.position = 'absolute';
    style.left = left + 'px';
    style.top = top + 'px';
    style.width = width + 'px';
    style.height = height + 'px';
  }
  playFullScreen() {
    // this._videoEle.requestFullscreen();
  }
  isPlaying() {
    return this._isPlaying;
  }
  closeVideo() {
    const parent = this._videoEle.parentNode;
    parent.parentNode.removeChild(parent);
    console.log(parent);
  }
  getTotalTime() {
    return this._videoEle.duration;
  }
  pause() {
    this._videoEle.pause();
    this._isPlaying = false;
  }
  play() {
    this._videoEle.play();
  }
  jumpWebActivity(url) {
    this._jumpWeb = window.open(url);
  }
  quitActivity() {
    this._jumpWeb.close();
  }
}
