// 导入清除插件,可以在每次打包之前，清除dist目录的内容；
require('babel-polyfill');
const MiniCssExtractPlugin = require('mini-css-extract-plugin');
const HtmlWebpackPlugin = require('html-webpack-plugin');
const path = require('path');
module.exports = {
  entry: {
    home: path.resolve(__dirname, './../src/home/index.js'), //入口js文件位置，__dirname为当前项目根目录
    pause: path.resolve(__dirname, './../src/detail/pause/index.js'),
    openscreen: path.resolve(__dirname, './../src/detail/openscreen/index.js'),
    front: path.resolve(__dirname, './../src/detail/front/index.js'),
    banner: path.resolve(__dirname, './../src/detail/banner/index.js'),
    carousal: path.resolve(__dirname, './../src/detail/carousal/index.js'),
    brokenscreen: path.resolve(
      __dirname,
      './../src/detail/broken-screen/index.js'
    ),
  },
  output: {
    path: path.resolve(__dirname + './../dist'), //输出文件位置
    filename: '[name]-[hash:8].bundle.js', //输出文件位置和名字，[name] 代表输出文件名和入口文件名一致
  },
  module: {
    rules: [
      //配置打包文件匹配规则，限制什么文件使用什么解释器
      {
        test: /\.js$/,
        // exclude: path.resolve(__dirname, './../node_modules'),
        use: {
          loader: 'babel-loader',
          options: {
            presets: ['@babel/preset-env'],
            plugins: ['@babel/plugin-proposal-class-properties'], // 转换class语法可以设置属性
          },
        },
      },
      {
        test: /\.(css|scss)$/,
        use: [MiniCssExtractPlugin.loader, 'css-loader', 'sass-loader'],
      },
      {
        test: /.html$/,
        use: {
          loader: 'html-loader',
          options: {
            attrs: ['img:src', 'a:href', 'video:src'], // 配置要解释的属性， 默认只解释img:src
          },
        },
      },
      {
        test: /\.tpl$/,
        loader: 'ejs-loader',
        options: {
          esModule: false,
        },
      },
      {
        test: /\.(png|jpg|gif|mp4|pdf|zip)$/,
        use: [
          {
            loader: 'url-loader',
            options: {
              esModule: false,
              outputPath: 'assets/', // 输出位置
              limit: 3 * 1028, // 小于这个大小会转换成base64格式
            },
          },
        ],
      },
    ],
  },
  plugins: [
    new MiniCssExtractPlugin(),
    new HtmlWebpackPlugin({
      filename: 'index.html', //打包后生成的文件名
      template: path.resolve(__dirname, '../src/home/index.html'), //入口html文件位置
      favicon: path.resolve('favicon.ico'),
      chunks: ['home'], // 配置的值为上面entry中配置的入口key,表示要引入的js文件
    }),
    new HtmlWebpackPlugin({
      filename: 'pause.html',
      template: path.resolve(__dirname, '../src/detail/pause/index.html'),
      favicon: path.resolve('favicon.ico'),
      chunks: ['pause'],
    }),
    new HtmlWebpackPlugin({
      filename: 'openscreen.html',
      template: path.resolve(__dirname, '../src/detail/openscreen/index.html'),
      favicon: path.resolve('favicon.ico'),
      chunks: ['openscreen'],
    }),
    new HtmlWebpackPlugin({
      filename: 'front.html',
      template: path.resolve(__dirname, '../src/detail/front/index.html'),
      favicon: path.resolve('favicon.ico'),
      chunks: ['front'],
    }),
    new HtmlWebpackPlugin({
      filename: 'banner.html',
      template: path.resolve(__dirname, '../src/detail/banner/index.html'),
      favicon: path.resolve('favicon.ico'),
      chunks: ['banner'],
    }),
    new HtmlWebpackPlugin({
      filename: 'brokenscreen.html',
      template: path.resolve(
        __dirname,
        '../src/detail/broken-screen/index.html'
      ),
      favicon: path.resolve('favicon.ico'),
      chunks: ['brokenscreen'],
    }),
    new HtmlWebpackPlugin({
      filename: 'carousal.html',
      template: path.resolve(__dirname, '../src/detail/carousal/index.html'),
      favicon: path.resolve('favicon.ico'),
      chunks: ['carousal'],
    }),
  ],
};
