const common = require('./webpack.common');
const webpack = require('webpack');
const { merge } = require('webpack-merge');
const path = require('path');
// 带plugin的需要在此配置require
const HtmlWebpackPlugin = require('html-webpack-plugin');
const MiniCssExtractPlugin = require('mini-css-extract-plugin');

module.exports = merge(common, {
  mode: 'development',
  entry: {
    home: path.resolve(__dirname, './../src/home/index.js'), //入口js文件位置，__dirname为当前项目根目录
    pause: path.resolve(__dirname, './../src/detail/pause/index.js'),
    openscreen: path.resolve(__dirname, './../src/detail/openscreen/index.js'),
    front: path.resolve(__dirname, './../src/detail/front/index.js'),
    banner: path.resolve(__dirname, './../src/detail/banner/index.js'),
  },
  output: {
    path: path.resolve(__dirname + './../dist'), //输出文件位置
    filename: '[name]-[hash:8].bundle.js', //输出文件位置和名字，[name] 代表输出文件名和入口文件名一致
  },
  plugins: [
    // 设置全局变量
    new webpack.DefinePlugin({
      'process.env': "'development'",
    }),
    new MiniCssExtractPlugin(),
    new HtmlWebpackPlugin({
      filename: 'index.html', //打包后生成的文件名
      template: path.resolve(__dirname, '../src/home/index.html'), //入口html文件位置
      favicon: path.resolve('favicon.ico'),
      chunks: ['home'], // 配置的值为上面entry中配置的入口key,表示要引入的js文件
    }),
    new HtmlWebpackPlugin({
      filename: 'pause.html',
      template: path.resolve(__dirname, '../src/detail/pause/index.html'),
      favicon: path.resolve('favicon.ico'),
      chunks: ['pause'],
    }),
    new HtmlWebpackPlugin({
      filename: 'openscreen.html',
      template: path.resolve(__dirname, '../src/detail/openscreen/index.html'),
      favicon: path.resolve('favicon.ico'),
      chunks: ['openscreen'],
    }),
    new HtmlWebpackPlugin({
      filename: 'front.html',
      template: path.resolve(__dirname, '../src/detail/front/index.html'),
      favicon: path.resolve('favicon.ico'),
      chunks: ['front'],
    }),
    new HtmlWebpackPlugin({
      filename: 'banner.html',
      template: path.resolve(__dirname, '../src/detail/banner/index.html'),
      favicon: path.resolve('favicon.ico'),
      chunks: ['banner'],
    }),
  ],
  devtool: 'cheap-module-eval-source-map',
  devServer: {
    open: true, //开启本地服务时是否打开浏览器
    // host: '192.168.3.2', //本地服务地址
    // host: '192.168.43.160', //本地服务地址
    hotOnly: true,
    port: 3500, ////本地服务端口

    proxy: [
      {
        context: ['/feedback/app', '/thirdyda', '/feedback/err'],
        target: 'http://adtest.yys.mgtv.com/',
        // 默认情况下，代理时会保留主机头的来源，可以将 changeOrigin 设置为 true 以覆盖此行为
        changeOrigin: true,
        // 默认情况下，将不接受在 HTTPS 上运行且证书无效的后端服务器。 如果需要,设置为false
        secure: false,
      },
      {
        context: ['/cdn'],
        target: 'http://adc.yys.mgtv.com/',
        changeOrigin: true,
        secure: false,
      },
      {
        context: ['/ad/ssp/iptv/config', '/user/getAreaCode', '/ssp/api/ad'],
        target: 'http://mock-api.com/VnZA4lgw.mock/',
        changeOrigin: true,
        secure: false,
      },
    ],
  },
});
