const webpack = require('webpack');
const { merge } = require('webpack-merge');
const { CleanWebpackPlugin } = require('clean-webpack-plugin');
const CopyWebpackPlugin = require('copy-webpack-plugin');
const path = require('path');
const common = require('./webpack.common');
module.exports = merge(common, {
  mode: 'production',
  devtool: false,
  plugins: [
    new CleanWebpackPlugin(),
    new webpack.DefinePlugin({
      'process.env': "'production'",
    }),
    // 静态资源迁移
    new CopyWebpackPlugin([
      {
        from: path.resolve(__dirname, './../src/assets'),
        to: path.resolve(__dirname, './../dist/assets'),
      },
    ]),
  ],
});
