import './index.scss';
import '../../sdk/adunion.min';
import { VideoPlayer } from '../../model/videoPlayerModel';
import $ from '../../utils/dom';
import clientParams from '../../model/exampleClient';

(() => {
  adunion.init(clientParams);

  let adspacePause = {
    width: 1920,
    height: 1080,
    maxAdCount: 1,
    maxDuration: 15,
    minCpm: 5,
  };

  const eventCallBack = (status) => {
    console.log(status);
    if (status === 'preplay') {
      $('.content').show();
    }
  };

  window.onload = () => {
    console.log(document.getElementsByClassName('videoContent'));
    const videoPlayer = new VideoPlayer(
      document.getElementsByClassName('videoContent')[0]
    );
    adunion.fetchOpenScreenAd(adspacePause).then((openScreenAd) => {
      console.log(openScreenAd);
      if(openScreenAd.status==1){
        openScreenAd.playAdVideo(videoPlayer, eventCallBack);
      }else{
        console.log('没有广告')
      }
    });
  };
})();
