function trimUrlHost(url) {
  console.log(url);
  if(url){
    return url.replace(/\[HOST\]/, '').replace('http://10.200.10.5:80', '');
  }else{
    return ''
  }
}

/**
 * 获取当前访问IP地址后三位 如a.b.c.d 则为b.c.d
 * @param {*} params
 */
function getUrlHostEnd3(params) {
  const hostName = window.location.hostname;
  const isIpAddr = /[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}/.test(hostName);
  if (isIpAddr) {
    return hostName.replace(/[0-9]{1,3}./, '');
  } else {
    return '';
  }
}

/**
 * 从曝光地址中获取sts的值
 * @param {曝光地址集合} impressionObjs
 * @returns
 */
function getStsFromUrl(impressionObjs) {
  if (impressionObjs) {
    let sts = '';
    for (var impressionObj of impressionObjs) {
      const mr = impressionObj.url.match(/sts=(\d+)&/);
      if (mr) {
        return mr[1];
      }
    }
  }
  return '';
}

module.exports = {
  trimUrlHost,
  getUrlHostEnd3,
  getStsFromUrl,
};
